<?php

namespace App\Http\Controllers;

use App\Models\Evaluation;
use Illuminate\Http\Request;
use App\Models\EvaluationValue;
use App\Http\Requests\StoreEvaluationValueRequest;
use App\Http\Requests\UpdateEvaluationValueRequest;

class EvaluationValueController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($evaluationId)
    {
        $evaluations = Evaluation::get();
        $evaluation = Evaluation::find($evaluationId);
        $evaluationValues =  EvaluationValue::with('evaluation')->where('evaluation_id',$evaluationId)->get();
        return view('evaluation-values.list')->with(['evaluationValues'=>$evaluationValues,'evaluation'=>$evaluation,'evaluations'=>$evaluations]);
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreEvaluationValueRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreEvaluationValueRequest $request)
    {
        $request->validate([
            'name' => 'required',
        ], [
            'name.required' => 'يرجى اضافة بند التقييم .']);
            try {

                $newEvaluationValue = new EvaluationValue();
                $newEvaluationValue->name = $request->name; 
                $newEvaluationValue->evaluation_id = $request->evaluationId;
                
                $newEvaluationValue->save();
                return back()->with(['success' => 'تم إضافة بند التقييم بنجاح     ']);
            } catch (\Throwable$th) {
                return back()->with(['error' => 'لم يتم إضافة  بند التقييم بنجاح   ']);
            }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateEvaluationValueRequest  $request
     * @param  \App\Models\EvaluationValue  $evaluationValue
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateEvaluationValueRequest $request, EvaluationValue $evaluationValue)
    {
       
        try {

            $updateEvaluationValue =  EvaluationValue::find($request->id);
            $updateEvaluationValue->name = $request->name; 
            $updateEvaluationValue->evaluation_id = $request->evaluationId;
            $updateEvaluationValue->update();
            return back()->with(['success' => 'تم تحديث بند التقييم بنجاح     ']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث  بند التقييم بنجاح   ']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\EvaluationValue  $evaluationValue
     * @return \Illuminate\Http\Response
     */
    public function destroy(EvaluationValue $evaluationValue,Request $request)
    {
        try {
            EvaluationValue::find($request->id)->delete();
            return back()->with(['success' => 'تمت حذف بند التقييم بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم حذف بند التقييم ']);
        }
    }
 /**
     * [Active and not active ]
     *
     * @param Request $request
     * 
     * @return [type]
     * 
     */
    public function toggle(Request $request)
    {
        try {
            $student = EvaluationValue::find($request->id);
            $student->is_active *= -1;
            $student->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }
}

